
#ifndef _1_MNG_TST_Utils_h_H
#define _1_MNG_TST_Utils_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#include "DX_VOS_BaseTypes.h"
#include "MNG_Functions.h"

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Sep 11 10:39:43 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version MNG_TST_Utils.h#1:incl:1
   *  \author NogaD
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
   
  
/************************ Defines ******************************/
/************************ Enums ********************************/
/************************ Typedefs  ****************************/
/************************ Structs  ******************************/
/************************ Public Variables **********************/
/************************ Public Functions **********************/
/*****************************************************************************
 * Function Name:                                                           
 * 	MNG_TST_CheckErrorReturn 		
 * 
 * Inputs:
 * 	DxUint32_t  TST_ErrorRet - The return value of the checked function
 *  char TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name 
 *  char 	 TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
 *  char 	 TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name 
 *
 * Outputs:
 * 	DxUint8_t - Function error return		    					  		
 *
 * Description:																	
 * This function Is a utility function to save up some space 
 * this function returns the appropriate printing for a checked function 
 * If the operation has succeeded of failed	the appropriate printing and return value
 *
 ******************************************************************************/
 DxError_t MNG_TST_CheckErrorReturn(DxError_t  TST_ErrorRet,
                                    char       TST_FuncName[TST_FUNC_STRING_LEN],
                                    char       TST_SubTestName[TST_FUNC_STRING_LEN],
                                    char       TST_MasterTestName[TST_FUNC_STRING_LEN]);
                                    
/*****************************************************************************
 * Function Name:
 *  MNG_TST_CheckErrorReturn_Expected
 *
 * Inputs:
 *  DxUint32_t  TST_ErrorRet - The return value of the checked function
 *  DxUint32_t  TST_ExpectedRet - The expected return value 
 *  char TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name
 *  char     TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
 *  char     TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name
 *
 * Outputs:
 *  DxUint8_t - Function error return
 *
 * Description:
 * This function Is a utility function to save up some space
 * this function returns the appropriate printing for a checked function
 * If the operation has succeeded as expected of failed the appropriate printing 
 * and return value
 *
 ******************************************************************************/
DxError_t MNG_TST_CheckErrorReturn_Expected(DxError_t  TST_ErrorRet,
											DxError_t  TST_ExpectedRet,
                                            char       TST_FuncName[TST_FUNC_STRING_LEN],
  		                                    char       TST_SubTestName[TST_FUNC_STRING_LEN],
		                                    char       TST_MasterTestName[TST_FUNC_STRING_LEN]);
		                                                                        
/*****************************************************************************
 * Function Name:                                                           
 * 	MNG_LOG_TST 		
 * 
 * Inputs:
 * 	DxUint8_t level - the printing level if it is below the ATP_LOG_TST_MAX_LEVEL_ENABLED
 *                    flag setting it will not be printed.
 * 	const char format,... - the printf format.	 
 *  
 * Outputs:
 *   None	    					  		
 *
 * Description:																	
 * The following function handles the printings logging of the testing suite . 
 *        This function should be called by using the KMNG_LOG_TST_PRINT macro
 *
 ******************************************************************************/							     
 #if ATP_LOG_TST_MAX_LEVEL_ENABLED
        int MNG_LOG_TST( DxUint8_t level , const char *format,... );
 #endif

 #if ATP_LOG_TST_MAX_LEVEL_ENABLED
        #define MNG_LOG_TST_PRINT(args) (MNG_LOG_TST args)
 #else
        #define MNG_LOG_TST_PRINT(args)   
 #endif
 
 /*****************************************************************************
 * Function Name:
 *  MNG_LOG_TST
 *
 * Inputs:
 *  DxUint32_t *TST_CounterBuffPtr - The buffer containing the counter.
 *  DxUint32_t TST_Val - The value to add
 *  DxUint8_t  TST_ConterSize - the counter size in 32bit words
 *
 * Outputs:
 *   None
 *
 * Description:
 * 		This function adds a value to a large counter presented in a buffer.
 *      The LSB of the counter is stored in the first cell in the array.
 *
 ******************************************************************************/
                              
 void MNG_TST_IncLsbUnsignedCounter(DxUint32_t *TST_CounterBuffPtr,
                                    DxUint32_t TST_Val,
                                    DxUint8_t  TST_CounterSize );	
                                    
/*****************************************************************************
 * Function Name:
 *  MNG_TST_Reset_SEP
 *
 * Inputs:
 * 	N/A
 *
 * Outputs:
 *   None
 *
 * Description:
 * 		This function performs a SW reset to the SEP
 *
 ******************************************************************************/
 DxError_t MNG_TST_Reset_SEP(void);    
 
  /*****************************************************************************
 * Function Name:
 *  MNG_TST_Reset_SEP_No_ClearIndication
 *
 * Inputs:
 * 	N/A
 *
 * Outputs:
 *   None
 *
 * Description:
 * 		This function performs a SW reset to the SEP
 *
 ******************************************************************************/
 DxError_t MNG_TST_Reset_SEP_No_ClearIndication(void);
 
 /*****************************************************************************
 * Function Name:
 *  MNG_TST_Snapshot_SEP
 *
 * Inputs:
 * 	N/A
 *
 * Outputs:
 *   None
 *
 * Description:
 * 		This function performs snapshot
 *
 ******************************************************************************/
 void MNG_TST_Snapshot_SEP(void);
 
 /*****************************************************************************
 * Function Name:
 *  MNG_TST_Reset_SEP_WarmBoot
 *
 * Inputs:
 * 	N/A
 *
 * Outputs:
 *   None
 *
 * Description:
 * 		This function performs a SW reset to the SEP
 *
 ******************************************************************************/
 DxError_t MNG_TST_Reset_SEP_WarmBoot(void);                                						     

 /*****************************************************************************
 * Function Name:
 *  MNG_ATP_Print_Version
 *
 * Inputs:
 * 	SEP_Version_t TST_Version - component version
 *
 * Outputs:
 *   None
 *
 * Description:
 * 		This function prints a given version
 *
 ******************************************************************************/ 
 void MNG_ATP_Print_Version(SEP_Version_t TST_Version, MwVersionInfo_t TST_MW_Version);

#ifdef __cplusplus
}
#endif

#endif



